/* Wiktor Zychla, 2003. IterIsolate: Eric Gunnerson */
using System;
using System.Collections;

namespace Example
{
  public class IterIsolate: IEnumerable
  {
    internal class IterIsolateEnumerator: IEnumerator
    {
      protected ArrayList items;
      protected int currentItem;

      internal IterIsolateEnumerator(IEnumerator enumerator)
      {
        IterIsolateEnumerator chainedEnumerator = 
          enumerator as IterIsolateEnumerator;

        if (chainedEnumerator != null)
        {
          items = chainedEnumerator.items;
        }
        else
        {
          items = new ArrayList();
          while (enumerator.MoveNext() != false)
          {
            items.Add(enumerator.Current);
          }
          IDisposable disposable = enumerator as IDisposable;
          if (disposable != null)
          {
            disposable.Dispose();
          }
        }
        currentItem = -1;
      }

      public void Reset()
      {
        currentItem = -1;
      }

      public bool MoveNext()
      {
        currentItem++;
        if (currentItem == items.Count)
          return false;

        return true;
      }

      public object Current
      {
        get
        {
          return items[currentItem];
        }
      }
    }

    public IterIsolate(IEnumerable enumerable)
    {
      this.enumerable = enumerable;
    }

    public IEnumerator GetEnumerator()
    {
      return new IterIsolateEnumerator(enumerable.GetEnumerator());
    }

    protected IEnumerable enumerable;
  }

  public class CExample 
  {
    public static void Main(string[] args)
    {
       ArrayList atab = new ArrayList();		

       atab.Add( 5 );
       atab.Add( 10 );
       atab.Add( 3 );

       foreach ( int i in new IterIsolate( atab ) )
         if ( i < 4 )
           atab.Remove( i );
    }
  }
}
